// priorityQ.java
// demonstruje dziaanie kolejki priorytetowej
// uruchomienie programu: C>java PriorityQApp
////////////////////////////////////////////////////////////////
class PriorityQ
   {
   // tablica uporzdkowana, maksymalny element na pozycji 0,
   // minimalny na pozycji nItems-1
   private int maxSize;
   private long[] queArray;
   private int nItems;
//-------------------------------------------------------------
   public PriorityQ(int s)          // konstruktor
      {
      maxSize = s;
      queArray = new long[maxSize];
      nItems = 0;
      }
//-------------------------------------------------------------
   public void insert(long item)    // wstawienie elementu
      {
      int j;

      if(nItems==0)                         // jeeli nie ma elementw...
         queArray[nItems++] = item;         // ...wstawiamy na pozycji 0
      else                                // jeeli s...
         {
         for(j=nItems-1; j>=0; j--)         // ...zaczynamy na kocu tablicy
            {
            if( item > queArray[j] )      // jeeli nowy element wikszy...
               queArray[j+1] = queArray[j]; // ...przesuwamy w gr
            else                          // jeeli nie...
               break;                     // ...koniec przesuwania
            }  // end for
         queArray[j+1] = item;            // wstawiamy element
         nItems++;
         }  // koniec else (nItems > 0)
      }  // koniec insert()
//-------------------------------------------------------------
   public long remove()             // usunicie minimalnego elementu
      { return queArray[--nItems]; }
//-------------------------------------------------------------
   public long peekMin()            // podgldnicie minimalnego elementu
      { return queArray[nItems-1]; }
//-------------------------------------------------------------
   public boolean isEmpty()         // zwraca true, jeeli kolejka jest pusta
      { return (nItems==0); }
//-------------------------------------------------------------
   public boolean isFull()          // zwraca true, jeeli kolejka jest pena
      { return (nItems == maxSize); }
//-------------------------------------------------------------
   }  // koniec klasy PriorityQ
////////////////////////////////////////////////////////////////
class PriorityQApp
   {
   public static void main(String[] args)
      {      
      PriorityQ thePQ = new PriorityQ(5);
      thePQ.insert(30);
      thePQ.insert(50);
      thePQ.insert(10);
      thePQ.insert(40);
      thePQ.insert(20);

      while( !thePQ.isEmpty() )
         {
         long item = thePQ.remove();
         System.out.print(item + " ");  // 10, 20, 30, 40, 50
         }  // koniec while
      System.out.println("");
      }  // koniec main()
//-------------------------------------------------------------
   }  // koniec klasy PriorityQApp
////////////////////////////////////////////////////////////////
